/*
 * Decompiled with CFR 0.152.
 */
package familiarfauna.entities;

import com.google.common.collect.Sets;
import familiarfauna.api.FFSounds;
import familiarfauna.config.ConfigurationHandler;
import familiarfauna.init.ModLootTable;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowParent;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.IAnimals;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;

public class EntityTurkey
extends EntityAnimal
implements IAnimals {
    private static final Set<Item> TEMPTATION_ITEMS = Sets.newHashSet((Object[])new Item[]{Items.field_151014_N, Items.field_151081_bc, Items.field_151080_bb, Items.field_185163_cU});
    private static final DataParameter<Byte> TYPE = EntityDataManager.func_187226_a(EntityTurkey.class, (DataSerializer)DataSerializers.field_187191_a);
    public float wingRotation;
    public float destPos;
    public float oFlapSpeed;
    public float oFlap;
    public float wingRotDelta = 1.0f;

    public EntityTurkey(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.9f, 1.4f);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(TYPE, (Object)0);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIPanic((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIMate((EntityAnimal)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAITempt((EntityCreature)this, 1.0, false, TEMPTATION_ITEMS));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIFollowParent((EntityAnimal)this, 1.1));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(7.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.oFlap = this.wingRotation;
        this.oFlapSpeed = this.destPos;
        this.destPos = (float)((double)this.destPos + (double)(this.field_70122_E ? -1 : 4) * 0.3);
        this.destPos = MathHelper.func_76131_a((float)this.destPos, (float)0.0f, (float)1.0f);
        if (!this.field_70122_E && this.wingRotDelta < 1.0f) {
            this.wingRotDelta = 1.0f;
        }
        this.wingRotDelta = (float)((double)this.wingRotDelta * 0.9);
        if (!this.field_70122_E && this.field_70181_x < 0.0) {
            this.field_70181_x *= 0.6;
        }
        this.wingRotation += this.wingRotDelta * 2.0f;
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    protected SoundEvent func_184639_G() {
        return FFSounds.turkey_ambient;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return FFSounds.turkey_hurt;
    }

    protected SoundEvent func_184615_bR() {
        return FFSounds.turkey_dead;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(FFSounds.turkey_step, 0.15f, 1.0f);
    }

    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        tagCompound.func_74768_a("TurkeyType", this.getTurkeyType());
    }

    public void func_70037_a(NBTTagCompound tagCompund) {
        super.func_70037_a(tagCompund);
        this.setTurkeyType(tagCompund.func_74762_e("TurkeyType"));
    }

    public EntityTurkey createChild(EntityAgeable ageable) {
        return new EntityTurkey(this.field_70170_p);
    }

    public boolean func_70877_b(ItemStack stack) {
        return TEMPTATION_ITEMS.contains(stack.func_77973_b());
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return ModLootTable.TURKEY_LOOT;
    }

    protected boolean canMate() {
        return !this.func_70631_g_() && this.func_110143_aJ() >= this.func_110138_aP() && this.func_70880_s();
    }

    public boolean func_70878_b(EntityAnimal otherAnimal) {
        if (otherAnimal instanceof EntityTurkey) {
            EntityTurkey turkey = (EntityTurkey)otherAnimal;
            if (this.getTurkeyType() != turkey.getTurkeyType()) {
                return this.canMate() && turkey.canMate();
            }
        }
        return false;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && !ConfigurationHandler.turkeyEnable) {
            this.func_70106_y();
        }
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData livingdata) {
        livingdata = super.func_180482_a(difficulty, livingdata);
        int i = this.field_70146_Z.nextInt(2);
        boolean flag = false;
        if (livingdata instanceof TurkeyTypeData) {
            i = ((TurkeyTypeData)livingdata).typeData;
            flag = true;
        } else {
            livingdata = new TurkeyTypeData(i);
        }
        this.setTurkeyType(i);
        return livingdata;
    }

    public int getTurkeyType() {
        return ((Byte)this.field_70180_af.func_187225_a(TYPE)).byteValue();
    }

    public void setTurkeyType(int turkeyTypeId) {
        this.field_70180_af.func_187227_b(TYPE, (Object)((byte)turkeyTypeId));
    }

    public static class TurkeyTypeData
    implements IEntityLivingData {
        public int typeData;

        public TurkeyTypeData(int type) {
            this.typeData = type;
        }
    }
}

